/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.layer.CaveLayer;
import com.yungnickyoung.minecraft.bettercaves.worldgen.layer.CavernLayer;
import com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion.LiquidRegionsController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_6350;
import net.minecraft.class_6643;
import net.minecraft.class_6880;

public class MasterController {
    private final class_3218 serverLevel;
    private final BetterCavesWorldCarverConfig config;
    private final List<CaveLayer> caveLayers = new ArrayList<CaveLayer>();
    private final List<CavernLayer> cavernLayers = new ArrayList<CavernLayer>();
    private final Set<class_1923> carvedChunkCache = new HashSet<class_1923>();

    public MasterController(class_3218 serverLevel, BetterCavesWorldCarverConfig config) {
        this.serverLevel = serverLevel;
        this.config = config;
        config.caveLayers.forEach(caveLayerSettings -> this.caveLayers.add(new CaveLayer(serverLevel, config, (BetterCavesWorldCarverConfig.CaveLayerSettings)caveLayerSettings)));
        config.cavernLayers.forEach(cavernLayerSettings -> this.cavernLayers.add(new CavernLayer(serverLevel, config, (BetterCavesWorldCarverConfig.CavernLayerSettings)cavernLayerSettings)));
        BetterCavesCommon.LOGGER.debug("MASTER CONTROLLER INITIALIZED");
    }

    public boolean carve(class_2791 chunkAccess, Function<class_2338, class_6880<class_1959>> biomeProvider, class_6643 carvingMask, class_6350 aquifer) {
        if (this.carvedChunkCache.contains(chunkAccess.method_12004())) {
            return false;
        }
        int[][] surfaceAltitudes = this.getSurfaceAltitudes(chunkAccess);
        class_2680[][] liquidBlocks = LiquidRegionsController.getInstance().hasSettingsForLevel(this.serverLevel) ? LiquidRegionsController.getInstance().getLiquidRegionsForServerLevel(this.serverLevel).getOrCreateLiquidBlocksForChunk(chunkAccess.method_12004()).liquidBlocks() : new class_2680[16][16];
        this.caveLayers.forEach(caveLayer -> caveLayer.carveChunk(chunkAccess, surfaceAltitudes, liquidBlocks, biomeProvider, carvingMask, aquifer));
        this.cavernLayers.forEach(cavernLayer -> cavernLayer.carveChunk(chunkAccess, surfaceAltitudes, liquidBlocks, biomeProvider, carvingMask, aquifer));
        this.carvedChunkCache.add(chunkAccess.method_12004());
        return true;
    }

    private int[][] getSurfaceAltitudes(class_2791 chunkAccess) {
        int[][] surfaceAltitudes = new int[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                surfaceAltitudes[x][z] = this.config.misc.overrideSurfaceDetection() ? 1 : Math.min(chunkAccess.method_12005(class_2902.class_2903.field_13194, x, z), chunkAccess.method_12005(class_2902.class_2903.field_13195, x, z));
            }
        }
        return surfaceAltitudes;
    }
}

